/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWUserInfo;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWebAppComboBox;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWConfirmYesNoDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWLocaleListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWLineBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import filenet.vw.toolkit.utils.uicontrols.security.IVWRecipientSelectionPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientComboPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientFilterPanel;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskField;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskMacros;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public final class VWUserPreferencesDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    private VWSessionInfo m_sessionInfo = null;
    private VWUserInfo m_userInfo = null;
    private Frame m_parentFrame = null;
    private JTextField m_emailAddress = null;
    private VWMaskField m_returnSetSizeField = null;
    private Integer m_returnSetSize = null;
    private VWWebAppComboBox m_webAppCombo = null;
    private JCheckBox m_newAssignment = null;
    private JCheckBox m_reminders = null;
    private JCheckBox m_expiredStepDeadline = null;
    private JCheckBox m_newTrackerAssignment = null;
    private JCheckBox m_reminderWorkflowDeadline = null;
    private JCheckBox m_expiredWorkflowDeadline = null;
    private JCheckBox m_workflowException = null;
    private JCheckBox m_trackerExpiredStepDeadline = null;
    private JCheckBox m_milestoneTracker = null;
    private JCheckBox m_milestoneOriginator = null;
    private JComboBox m_localeCombo = null;
    private JCheckBox m_outOfOfficeCheckBox = null;
    private IVWRecipientSelectionPanel m_recipientSelectionPanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public VWUserPreferencesDialog(Frame parent, VWSessionInfo sessionInfo) {
        super(parent);
        if (sessionInfo == null) {
            return;
        }
        this.m_sessionInfo = sessionInfo;
        this.m_parentFrame = parent;
        try {
            this.m_userInfo = this.m_sessionInfo.getSession().fetchCurrentUserInfo();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.initControls();
    }

    public int getMaxRowsReturn() {
        if (this.m_returnSetSize != null) {
            return this.m_returnSetSize;
        }
        return -1;
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_outOfOfficeCheckBox)) {
            this.resetSelectedPerson(null);
        } else if (event.getSource().equals(this.m_recipientSelectionPanel)) {
            if (!this.checkUser()) {
                this.m_recipientSelectionPanel.reset();
            }
            this.setButtonState();
        } else if (event.getSource().equals(this.m_okButton)) {
            if (!this.saveChanges()) {
                return;
            }
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_cancelButton)) {
            this.setVisible(false);
            if (this.m_returnSetSizeField != null && this.m_returnSetSize != null) {
                this.m_returnSetSizeField.setText(this.m_returnSetSize.toString());
            }
            this.refreshControls();
        } else if (event.getSource().equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfwm014.htm");
        }
    }

    private void initControls() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_userPreferencesDialogDimensions);
            if (dim == null) {
                this.setSize(420, 350);
            } else {
                this.setSize(dim);
            }
            this.setVisible(false);
            this.setTitle(VWResource.s_userPreferences);
            this.getContentPane().add((Component)this.getTopPanel(), "First");
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            tabbedPane.add(VWResource.s_general, this.getGeneralPanel());
            tabbedPane.add(VWResource.s_notification, this.getNotificationPreferencesPanel());
            tabbedPane.add(VWResource.s_outOfOffice, this.getOutOfOfficeSettingPanel());
            this.getContentPane().add((Component)tabbedPane, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
            this.refreshControls();
            this.setButtonState();
            this.addWindowListener(new VWWindowAdapter(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getTopPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(5, 5, 5, 10);
            panel.add((Component)new JLabel(VWResource.s_nameColon), gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            if (this.m_userInfo != null) {
                String userName = this.m_userInfo.getName();
                try {
                    VWParticipant participant = this.m_userInfo.getNamePx();
                    if (participant != null && participant.getDisplayName() != null) {
                        userName = participant.getDisplayName();
                    }
                }
                catch (Exception ex1) {
                    VWDebug.logException(ex1);
                }
                panel.add((Component)new JLabel(userName), gbCons);
            } else {
                panel.add((Component)new JLabel(VWResource.s_undefinedUserName), gbCons);
            }
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getGeneralPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(5, 10, 5, 0);
            panel.add((Component)new JLabel(VWResource.s_emailAddressColon), gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_emailAddress = new JTextField(20);
            panel.add((Component)this.m_emailAddress, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_maxRowsReturnedPerSetColon), gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            VWMaskMacros macros = new VWMaskMacros();
            macros.addMacro('#', "[0-9]");
            this.m_returnSetSizeField = new VWMaskField("#######", macros, ' ');
            this.m_returnSetSizeField.setColumns(7);
            panel.add((Component)this.m_returnSetSizeField, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)new JLabel(VWResource.s_defaultWebApp), gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_webAppCombo = new VWWebAppComboBox(true);
            this.m_webAppCombo.setRenderer(new VWLabelListCellRenderer());
            panel.add((Component)this.m_webAppCombo, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            panel.add((Component)new JLabel(" "), gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return new JPanel();
        }
    }

    private JPanel getNotificationPreferencesPanel() {
        try {
            if (this.m_userInfo == null) {
                return null;
            }
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            Insets indentInsets = new Insets(0, 8, 0, 0);
            Insets borderInsets = new Insets(5, 10, 5, 0);
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = borderInsets;
            JPanel stepNotification = new JPanel();
            stepNotification.setLayout(new GridBagLayout());
            stepNotification.setBorder(new VWTitledBorder(VWResource.s_step));
            this.m_newAssignment = new JCheckBox(VWResource.s_newAssignment);
            gbCons.insets = indentInsets;
            stepNotification.add((Component)this.m_newAssignment, gbCons);
            this.m_reminders = new JCheckBox(VWResource.s_reminders);
            ++gbCons.gridy;
            stepNotification.add((Component)this.m_reminders, gbCons);
            this.m_expiredStepDeadline = new JCheckBox(VWResource.s_expiredStepDeadline);
            ++gbCons.gridy;
            stepNotification.add((Component)this.m_expiredStepDeadline, gbCons);
            gbCons.gridy = 0;
            gbCons.insets = borderInsets;
            panel.add((Component)stepNotification, gbCons);
            JPanel originatorNotification = new JPanel();
            originatorNotification.setLayout(new GridBagLayout());
            originatorNotification.setBorder(new VWTitledBorder(VWResource.s_originator));
            this.m_milestoneOriginator = new JCheckBox(VWResource.s_milestoneReached);
            gbCons.insets = indentInsets;
            originatorNotification.add((Component)this.m_milestoneOriginator, gbCons);
            gbCons.gridy = 1;
            gbCons.insets = borderInsets;
            panel.add((Component)originatorNotification, gbCons);
            JPanel trackerNotification = new JPanel();
            trackerNotification.setLayout(new GridBagLayout());
            trackerNotification.setBorder(new VWTitledBorder(VWResource.s_tracker));
            this.m_newTrackerAssignment = new JCheckBox(VWResource.s_newTrackerAssignment);
            gbCons.gridy = 0;
            gbCons.insets = indentInsets;
            trackerNotification.add((Component)this.m_newTrackerAssignment, gbCons);
            this.m_reminderWorkflowDeadline = new JCheckBox(VWResource.s_reminderWorkflowDeadline);
            ++gbCons.gridy;
            trackerNotification.add((Component)this.m_reminderWorkflowDeadline, gbCons);
            this.m_expiredWorkflowDeadline = new JCheckBox(VWResource.s_expiredWorkflowDeadline);
            ++gbCons.gridy;
            trackerNotification.add((Component)this.m_expiredWorkflowDeadline, gbCons);
            this.m_workflowException = new JCheckBox(VWResource.s_workflowException);
            ++gbCons.gridy;
            trackerNotification.add((Component)this.m_workflowException, gbCons);
            this.m_trackerExpiredStepDeadline = new JCheckBox(VWResource.s_expiredStepDeadline);
            ++gbCons.gridy;
            trackerNotification.add((Component)this.m_trackerExpiredStepDeadline, gbCons);
            this.m_milestoneTracker = new JCheckBox(VWResource.s_milestoneReached);
            ++gbCons.gridy;
            trackerNotification.add((Component)this.m_milestoneTracker, gbCons);
            gbCons.gridx = 1;
            gbCons.gridy = 0;
            gbCons.gridheight = 2;
            gbCons.insets = borderInsets;
            panel.add((Component)trackerNotification, gbCons);
            JPanel localePanel = new JPanel(new BorderLayout(5, 5));
            localePanel.setBorder(new VWLineBorder());
            localePanel.add((Component)new JLabel(VWResource.s_preferredLocale), "Before");
            Locale[] availableLocales = this.m_sessionInfo.getSession().fetchAvailableLocales();
            this.m_localeCombo = availableLocales != null && availableLocales.length > 0 ? new JComboBox<Locale>(availableLocales) : new JComboBox();
            this.m_localeCombo.insertItemAt(VWResource.s_systemDefined, 0);
            this.m_localeCombo.setRenderer(new VWLocaleListCellRenderer());
            localePanel.add((Component)this.m_localeCombo, "Center");
            gbCons.gridx = 0;
            gbCons.gridy = 3;
            gbCons.gridwidth = 2;
            gbCons.gridheight = 1;
            panel.add((Component)localePanel, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.gridheight = 1;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            panel.add((Component)new JLabel(" "), gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return new JPanel();
        }
    }

    private JPanel getOutOfOfficeSettingPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(5, 5, 10, 5);
            this.m_outOfOfficeCheckBox = new JCheckBox(VWResource.s_iAmOutOfOfice);
            this.m_outOfOfficeCheckBox.addActionListener(this);
            panel.add((Component)this.m_outOfOfficeCheckBox, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)new JLabel(VWResource.s_selectPersonToReceiveWork), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.m_recipientSelectionPanel = this.m_sessionInfo.getSession().getSecurityDatabaseType() == 1 ? new VWRecipientFilterPanel(this, this.m_sessionInfo.getSession()) : new VWRecipientComboPanel(this, this.m_sessionInfo.getSession());
            this.m_recipientSelectionPanel.addActionListener(this);
            panel.add((Component)((JPanel)((Object)this.m_recipientSelectionPanel)), gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return new JPanel();
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel(new FlowLayout());
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            panel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            panel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_helpDots);
            this.m_helpButton.addActionListener(this);
            panel.add(this.m_helpButton);
            if (this.m_userInfo == null) {
                this.m_okButton.setEnabled(false);
            }
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void setButtonState() {
        boolean bEnable = false;
        if (this.m_outOfOfficeCheckBox.isSelected()) {
            if (this.m_recipientSelectionPanel != null && this.m_recipientSelectionPanel.hasValidSelection()) {
                bEnable = true;
            }
        } else {
            bEnable = true;
        }
        this.m_okButton.setEnabled(bEnable && this.m_userInfo != null);
    }

    private void refreshControls() {
        try {
            int notificationFlags;
            if (this.m_userInfo == null) {
                return;
            }
            this.m_emailAddress.setText(this.m_userInfo.getEMailAddress());
            Object maxRowsValue = this.m_userInfo.getFieldValue("pwm_maxrows");
            if (maxRowsValue != null && maxRowsValue instanceof String) {
                this.m_returnSetSize = new Integer(maxRowsValue.toString());
                this.m_returnSetSizeField.setText(maxRowsValue.toString());
            } else {
                this.m_returnSetSize = new Integer(50);
                this.m_returnSetSizeField.setText(this.m_returnSetSize.toString());
            }
            if (this.m_webAppCombo != null) {
                this.m_webAppCombo.setSelectedWebApp(this.m_userInfo.getFieldValue("F_WebApp"));
            }
            if (((notificationFlags = this.m_userInfo.getNotificationFlags()) & 1) != 0) {
                this.m_newAssignment.setSelected(true);
            } else {
                this.m_newAssignment.setSelected(false);
            }
            if ((notificationFlags & 4) != 0) {
                this.m_reminders.setSelected(true);
            } else {
                this.m_reminders.setSelected(false);
            }
            if ((notificationFlags & 2) != 0) {
                this.m_expiredStepDeadline.setSelected(true);
            } else {
                this.m_expiredStepDeadline.setSelected(false);
            }
            if ((notificationFlags & 0x200) != 0) {
                this.m_milestoneOriginator.setSelected(true);
            } else {
                this.m_milestoneOriginator.setSelected(false);
            }
            if ((notificationFlags & 8) != 0) {
                this.m_workflowException.setSelected(true);
            } else {
                this.m_workflowException.setSelected(false);
            }
            if ((notificationFlags & 0x80) != 0) {
                this.m_trackerExpiredStepDeadline.setSelected(true);
            } else {
                this.m_trackerExpiredStepDeadline.setSelected(false);
            }
            if ((notificationFlags & 0x40) != 0) {
                this.m_reminderWorkflowDeadline.setSelected(true);
            } else {
                this.m_reminderWorkflowDeadline.setSelected(false);
            }
            if ((notificationFlags & 0x10) != 0) {
                this.m_expiredWorkflowDeadline.setSelected(true);
            } else {
                this.m_expiredWorkflowDeadline.setSelected(false);
            }
            if ((notificationFlags & 0x20) != 0) {
                this.m_newTrackerAssignment.setSelected(true);
            } else {
                this.m_newTrackerAssignment.setSelected(false);
            }
            if ((notificationFlags & 0x100) != 0) {
                this.m_milestoneTracker.setSelected(true);
            } else {
                this.m_milestoneTracker.setSelected(false);
            }
            this.m_localeCombo.setSelectedIndex(0);
            this.m_localeCombo.setEnabled(false);
            if (this.m_localeCombo.getModel().getSize() > 1) {
                this.m_localeCombo.setEnabled(true);
                Locale preferredLocale = this.m_userInfo.getPreferredLocale();
                if (preferredLocale != null) {
                    this.m_localeCombo.setSelectedItem(preferredLocale);
                }
            }
            this.refreshOutOfOfficePanel();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    private void refreshOutOfOfficePanel() {
        if (this.m_userInfo == null) {
            return;
        }
        boolean isOutOfOffice = false;
        VWParticipant assignee = null;
        try {
            assignee = this.m_userInfo.getProxyUserNamePx();
            isOutOfOffice = assignee != null;
        }
        catch (Exception ex) {
            isOutOfOffice = false;
            assignee = null;
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
        if (this.m_outOfOfficeCheckBox != null) {
            this.m_outOfOfficeCheckBox.setEnabled(true);
            this.m_outOfOfficeCheckBox.setSelected(isOutOfOffice);
            this.resetSelectedPerson(assignee);
        }
    }

    private void resetSelectedPerson(VWParticipant assignee) {
        this.m_recipientSelectionPanel.removeActionListener(this);
        if (this.m_outOfOfficeCheckBox.isSelected()) {
            this.m_recipientSelectionPanel.setEnabled(true);
        } else {
            this.m_recipientSelectionPanel.setEnabled(false);
        }
        this.m_recipientSelectionPanel.setSelectedValue(assignee);
        this.setButtonState();
        this.m_recipientSelectionPanel.addActionListener(this);
    }

    private boolean saveChanges() {
        try {
            Object selectedItem;
            if (this.m_userInfo == null) {
                return false;
            }
            this.m_userInfo.setEMailAddress(this.m_emailAddress.getText());
            Integer newReturnSetSize = null;
            String returnSetSizeTextValue = this.m_returnSetSizeField.getText();
            newReturnSetSize = returnSetSizeTextValue.length() == 0 ? new Integer(0) : new Integer(returnSetSizeTextValue);
            if (newReturnSetSize < 1) {
                JOptionPane.showMessageDialog(this, VWResource.s_returnSetSizeError.toString(VWResource.s_maxRowsReturnedPerSetColon), VWResource.s_errorMessage, 0);
                return false;
            }
            this.m_returnSetSize = newReturnSetSize;
            this.m_userInfo.setFieldValue("pwm_maxrows", returnSetSizeTextValue);
            if (this.m_webAppCombo != null) {
                Integer webApp = this.m_webAppCombo.getSelectedWebApp();
                if (webApp != null) {
                    this.m_userInfo.deleteField("F_WebApp");
                    if (webApp != 0) {
                        this.m_userInfo.setFieldValue("F_WebApp", webApp);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, VWResource.s_invalidWebApp, VWResource.s_errorMessage, 0);
                    return false;
                }
            }
            int nNotificationFlags = 0;
            if (this.m_newAssignment.isSelected()) {
                nNotificationFlags |= 1;
            }
            if (this.m_reminders.isSelected()) {
                nNotificationFlags |= 4;
            }
            if (this.m_expiredStepDeadline.isSelected()) {
                nNotificationFlags |= 2;
            }
            if (this.m_workflowException.isSelected()) {
                nNotificationFlags |= 8;
            }
            if (this.m_reminderWorkflowDeadline.isSelected()) {
                nNotificationFlags |= 0x40;
            }
            if (this.m_trackerExpiredStepDeadline.isSelected()) {
                nNotificationFlags |= 0x80;
            }
            if (this.m_expiredWorkflowDeadline.isSelected()) {
                nNotificationFlags |= 0x10;
            }
            if (this.m_newTrackerAssignment.isSelected()) {
                nNotificationFlags |= 0x20;
            }
            if (this.m_milestoneTracker.isSelected()) {
                nNotificationFlags |= 0x100;
            }
            if (this.m_milestoneOriginator.isSelected()) {
                nNotificationFlags |= 0x200;
            }
            this.m_userInfo.setNotificationFlags(nNotificationFlags);
            if (this.m_localeCombo.getModel().getSize() > 1 && (selectedItem = this.m_localeCombo.getSelectedItem()) != null && selectedItem instanceof Locale) {
                this.m_userInfo.setPreferredLocale((Locale)selectedItem);
            }
            if (!this.doAssign()) {
                return false;
            }
            this.m_userInfo.save();
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    private boolean doAssign() {
        try {
            if (this.m_userInfo == null) {
                return false;
            }
            VWParticipant selectedUser = null;
            if (this.m_outOfOfficeCheckBox.isSelected()) {
                if (this.m_recipientSelectionPanel != null && this.m_recipientSelectionPanel.hasValidSelection()) {
                    selectedUser = this.m_recipientSelectionPanel.getSelectedValue();
                    this.m_userInfo.setProxyUserNameByDomain(selectedUser.getDomainName(), selectedUser.getParticipantName());
                }
            } else {
                this.m_userInfo.setProxyUserName(null);
            }
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            return false;
        }
    }

    private boolean checkUser() {
        try {
            if (this.m_outOfOfficeCheckBox.isSelected()) {
                VWParticipant selectedUser = null;
                if (this.m_recipientSelectionPanel != null && this.m_recipientSelectionPanel.hasValidSelection()) {
                    selectedUser = this.m_recipientSelectionPanel.getSelectedValue();
                }
                if (selectedUser != null) {
                    VWUserInfo selectedUserInfo = this.m_sessionInfo.getSession().fetchUserInfo(selectedUser.getParticipantName());
                    if (selectedUserInfo != null && selectedUserInfo.getProxyUserName() != null) {
                        VWConfirmYesNoDialog dlg = new VWConfirmYesNoDialog(this.m_parentFrame, VWResource.s_userPreferences, VWResource.s_confirmAssign, 0);
                        dlg.setVisible(true);
                        return dlg.isYes();
                    }
                    return true;
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            return false;
        }
        return false;
    }
}

